## Concepts

A **Gantt chart** is a bar chart that shows time along a horizontal axis and activities placed as bars along the time line. Each activity has a start time and an end time.
Gantt charts are often used to depict planning and scheduling information and also in project management to represent work breakdown structures.

There are two types of Gantt chart: the **Scheduling chart** and the **Activity Chart**.

**Scheduling charts** show who is doing what and when in your plan. They are used to track simultaneous activities and resources. An **activity** is anything you want to plan, monitor or schedule over time. It has a start and end time (and consequently a duration). A **resource** can be human, machine, equipment or anything you want to use for the activities. A particular assignment of a resource to an activity is called a **reservation**.

For example, the following diagram shows part of a schedule chart for a building project in August and September. It shows both activities and the resources that are assigned, so that the workload for each resource can be monitored. Different activities (masonry, ceiling, plumbing etc.) are represented as color-coded bars for each resource along a timeline.
Several resources can work simultaneously on the same activity (masonry for example). Some resources work on different activities. Others work only on one type of activity (Steve for example only works on plumbing). The resources section also shows the staff grouped into teams. For example, Jane is responsible for Joe, Jack and Jim but she doesn’t undertake any of the work shown in this scheduling chart.
Any period that is not filled-in is a period where that resource is not used.

![alt text](images/concepts_schedule_chart.jpg 'Schedule Chart')

**Activity charts** also show when things happen, but they are organized according to the activities rather than the resources. Activities can be broken up into tasks and each task is represented as a horizontal bar along a time scale. You might have some restrictions concerning when different activities start or end in relation to each other. These dependencies are depicted by arrows between activities and are called **constraints**.

The following diagram shows part of an activity chart for a marketing project in March and April. It displays the order and timing in which different activities must take place. Each activity is broken down into tasks (for example, compiling the customer list and contacting customers are two tasks which make up the activity talking to customers). Arrows between the bars indicate dependencies between activities. For example, the first draft must be completed before the second draft of the marketing requirements can be written. This is indicated by an arrow which indicates that the end of the first draft must occur before the beginning of the second draft. This type of precedence constraint is very common in project management.

![alt text](images/concepts_activity_chart.jpg 'Activity Chart')
