
$( document ).ready(function() {
  $('.chat-content figure[data-trix-content-type^="video/"]').each(function(i, obj) {
    if(!$(this).find('video').length && !$(this).find('progress').length) {
      var tipo = $(this).data('trix-content-type');
      var linkelement = $(this).find('a');
      var link = linkelement.attr('href');
      $(this).prepend('<video controls width="500"> <source src="' + link + '" type="' + tipo + '"></video>');
      $('#content').val($('.trix-content').html());
    }
  });

  $('.chat-content a[href^="http"]').each(function(i, obj) {
    $('a[href^="http"]').attr('target','_blank');
  });
  var ticketid = $('#lista_tarefas_ticket').data('id');
  atualizar_lista_tickets(ticketid);
});

addEventListener("trix-file-accept", function(event) {
  const acceptedTypes = [
    'audio/aac',
    'application/x-abiword',
    'application/vnd.amazon.ebook',
    'application/octet-stream',
    'application/x-bzip',
    'application/x-bzip2',
    'application/x-rar-compressed',
    'application/x-7z-compressed',
    'application/msword',
    'application/vnd.ms-fontobject',
    'application/rtf',
    'application/x-tar',
    'image/x-icon',
    'text/calendar',
    'image/jpeg',
    'image/png',
    'image/gif',
    'image/tiff',
    'image/webp',
    'video/mp4',
    'video/mov',
    'video/webm',
    'video/mpeg',
    'video/ogg',
    'video/x-msvideo',
    'application/zip',
    'application/pdf',
    'application/vnd.ms-powerpoint',
    'text/csv',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'application/vnd.ms-excel',
    'application/vnd.oasis.opendocument.presentation',
    'application/vnd.oasis.opendocument.spreadsheet',
    'application/vnd.oasis.opendocument.text',
    'audio/ogg',
    'audio/x-wav',
    'audio/webm'
  ]

  if (!acceptedTypes.includes(event.file.type)) {
    event.preventDefault();
    alert("Ficheiro não suportado");
  }
});

$(document).on('click', '.delete_ticket', function() {
   var id = $(this).data('id');
   var assunto = $(this).data('assunto');
   $('#delete_ticket').find('input[name="id"]').val(id);
   $('#delete_ticket').find('.assunto_ticket').html(assunto);
   $('#delete_ticket').modal('show');
});

$(document).on("click", '.edit_ticket', function() {
  var id = $(this).data('id');
  $.ajax({
      url: '/app/elements/functions/ajax.php',
      type: 'POST',
      data: {"ajax": "obter_editar_ticket_modal", "id": id, "pagina": "ver_ticket"},
      cache: false,
      success: function(response){
        $('#edit_ticket .modal-body').html(response);
        $('#edit_ticket').modal('show');
      }
  });
});

var projetos = $('.addprojectcontainer').html();

$(document).on("click", '.addprojectbtn', function() {
  $('.addprojectcontainer').html('<label>Nome novo Projeto</label><a href="#" class="float-right selectprojectbtn">Selecionar projeto</a><input class="form-control" type="text" name="nome_projeto" required>');
});

$(document).on("click", '.selectprojectbtn', function() {
  $('.addprojectcontainer').html(projetos);
		$('.select').select2({
			minimumResultsForSearch: 10,
			width: '100%'
		});
});

function atualizar_lista_tickets(id){
  $.ajax({
      url: '/app/elements/functions/ajax.php',
      type: 'POST',
      data: {"ajax": "obter_tarefas_ticket", "id": id},
      cache: false,
      success: function(response){
        $('#lista_tarefas_ticket').html(response);
      }
  });
}
